package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerSoftDeleteVods(t *testing.T) {
	Convey("when calling ManagerSoftDeleteVods", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerSoftDeleteVodsRequest{
			VodIDs: []int64{testdata.VodID1},
			UserID: 1234,
		}

		Convey("when ManagerSoftDeleteVods succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("DeleteVodsExternal", ctx, mock.Anything, mock.Anything).Return([]*vinyl.Vod{vinylUpload}, nil)
			vods, err := backend.ManagerSoftDeleteVods(ctx, request)
			So(err, ShouldBeNil)
			So(len(vods.Vods), ShouldEqual, 1)
			So(vods.Vods[0], ShouldResemble, internalUpload)
		})
		Convey("when ManagerSoftDeleteVods fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("DeleteVodsExternal", ctx, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerSoftDeleteVods(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
