package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerUpdateUserVideoPrivacyProperties should make an underlying call to vinyl
func (b *backendImpl) ManagerUpdateUserVideoPrivacyProperties(ctx context.Context, request *models.ManagerUpdateUserVideoPrivacyPropertiesRequest) (*models.UserVideoPrivacyPropertiesResponse, error) {
	b.stats.Inc(managerUpdateUserVideoPrivacyPropertiesAttemptStatStr, 1, 1.0)

	setUserVideoPrivacyPropertiesInput := vinyl.UserVideoPrivacyPropertiesInput{
		HideArchives: request.HideArchives,
	}
	videoPrivacyProperties, err := b.vinyl.SetUserVideoPrivacyProperties(ctx, strconv.FormatInt(request.ChannelID, 10), setUserVideoPrivacyPropertiesInput, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylUserVideoPrivacyProperties(videoPrivacyProperties), nil
}
