package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerUpdateUserVideoPrivacyProperties(t *testing.T) {
	Convey("when calling ManagerUpdateUserVideoPrivacyProperties", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerUpdateUserVideoPrivacyPropertiesRequest{
			ChannelID:    1234,
			HideArchives: true,
			UserID:       1234,
		}

		Convey("when ManagerUpdateUserVideoPrivacyProperties succeeds", func() {
			userVideoPrivacyProperties := testdata.VinylUserVideoPrivacyProperties()
			mocks.vinyl.On("SetUserVideoPrivacyProperties", mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(userVideoPrivacyProperties, nil)
			thumbnailsResp, err := backend.ManagerUpdateUserVideoPrivacyProperties(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when ManagerUpdateUserVideoPrivacyProperties fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("SetUserVideoPrivacyProperties", mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerUpdateUserVideoPrivacyProperties(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
