package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"code.justin.tv/vod/vodapi/pkg/vinyl"
	"golang.org/x/net/context"
)

// ManagerUpdateUserVodProperties should make an underlying call to vinyl
func (b *backendImpl) ManagerUpdateUserVodProperties(ctx context.Context, request *models.ManagerUpdateUserVodPropertiesRequest) (*models.UserVodPropertiesResponse, error) {
	b.stats.Inc(managerUpdateUserVodPropertiesAttemptStatStr, 1, 1.0)

	updateUserVodPropertiesInput := &vinyl.UpdateUserVodPropertiesInput{
		ChannelID:                strconv.FormatInt(request.ChannelID, 10),
		SaveVodsForever:          request.SaveVodsForever,
		VodStorageDays:           request.VodStorageDays,
		CanUploadVod:             request.CanUploadVod,
		YoutubeExportingDisabled: request.YoutubeExportingDisabled,
		SkipUploadModeration:     request.SkipUploadModeration,
		SkipMuting:               request.SkipMuting,
		CanUploadUnlimited:       request.CanUploadUnlimited,
	}
	userVodProperties, err := b.vinyl.UpdateUserVodProperties(ctx, updateUserVodPropertiesInput, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylUserVodProperties(userVodProperties), nil
}
