package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerUpdateUserVodProperties(t *testing.T) {
	Convey("when calling ManagerUpdateUserVodProperties", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		saveVodsForever := true
		request := &models.ManagerUpdateUserVodPropertiesRequest{
			ChannelID:       1234,
			UserID:          1234,
			SaveVodsForever: &saveVodsForever,
		}

		Convey("when ManagerUpdateUserVodProperties succeeds", func() {
			userVodProperties := testdata.VinylUserVodProperties()
			mocks.vinyl.On("UpdateUserVodProperties", mock.Anything, mock.Anything, mock.Anything).Return(userVodProperties, nil)
			thumbnailsResp, err := backend.ManagerUpdateUserVodProperties(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when ManagerUpdateUserVodProperties fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("UpdateUserVodProperties", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerUpdateUserVodProperties(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
