package backend

import (
	"strconv"
	"strings"

	"code.justin.tv/foundation/twitchclient"
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	"golang.org/x/net/context"
)

// ManagerUpdateVod should make an underlying call to vinyl
func (b *backendImpl) ManagerUpdateVod(ctx context.Context, request *models.ManagerUpdateVodRequest) (*models.Vod, error) {
	b.stats.Inc(managerUpdateVodAttemptStatStr, 1, 1.0)

	var tagList string
	if len(request.TagList) > 0 {
		tagList = strings.Join(request.TagList, ",")
	}
	updateVodInput := &vinyl.UpdateVodInput{
		BroadcastID:           request.BroadcastID,
		Description:           request.Description,
		Duration:              request.Duration,
		Game:                  request.Game,
		Communities:           &request.Communities,
		Language:              request.Language,
		Offset:                request.Offset,
		ShowFormats:           converters.ConvertToVinylShowFormats(request.ShowFormats),
		TagList:               &tagList,
		SelectedThumbnailPath: request.ThumbnailPath,
		URI:        request.URI,
		Title:      request.Title,
		ViewableAt: request.ViewableAt,
	}
	if request.BroadcastType != "" {
		updateVodInput.BroadcastType = utils.StrPtr(request.BroadcastType)
	}
	if request.Status != "" {
		updateVodInput.Status = utils.StrPtr(request.Status)
	}
	if request.Viewable != "" {
		updateVodInput.Viewable = utils.StrPtr(request.Viewable)
	}
	vinylVod, err := b.vinyl.UpdateVod(ctx, strconv.FormatInt(request.VodID, 10), updateVodInput, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
