package backend

import (
	"context"
	"errors"
	"strconv"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerUpdateVod(t *testing.T) {
	Convey("when calling ManagerUpdateVod", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerUpdateVodRequest{
			VodID:  testdata.VodID1,
			Title:  utils.StrPtr("title"),
			UserID: 1234,
		}

		Convey("when ManagerUpdateVod succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("UpdateVod", ctx, strconv.FormatInt(testdata.VodID1, 10), mock.Anything, mock.Anything).Return(vinylUpload, nil)
			vod, err := backend.ManagerUpdateVod(ctx, request)
			So(err, ShouldBeNil)
			So(internalUpload, ShouldResemble, vod)
		})
		Convey("when ManagerUpdateVod fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("UpdateVod", ctx, strconv.FormatInt(testdata.VodID1, 10), mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerUpdateVod(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
