package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"

	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// PublicGetVodByID should make an underlying call to vinyl
func (b *backendImpl) PublicGetVodByID(ctx context.Context, request *models.PublicGetVodByIDRequest) (*models.Vod, error) {
	b.stats.Inc(publicGetVodByIDAttemptStatStr, 1, 1.0)

	vinylVod, err := b.vinyl.GetVodByID(ctx, strconv.FormatInt(request.VodID, 10), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
