package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// PublicGetVodsByIDs should make an underlying call to vinyl
func (b *backendImpl) PublicGetVodsByIDs(ctx context.Context, request *models.PublicGetVodsByIDsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(publicGetVodsByIDsAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	vinylVods, err := b.vinyl.GetVodsByIDs(ctx, ids, nil, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
