package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestPublicGetVodsByIDs(t *testing.T) {
	Convey("when calling PublicGetVodsByIDs", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.PublicGetVodsByIDsRequest{
			VodIDs: []int64{testdata.VodID1},
		}

		Convey("when PublicGetVodsByIDs succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("GetVodsByIDs", ctx, mock.Anything, (*vinyl.GetVodParams)(nil), mock.Anything).Return([]*vinyl.Vod{vinylUpload}, nil)
			vods, err := backend.PublicGetVodsByIDs(ctx, request)
			So(err, ShouldBeNil)
			So(len(vods.Vods), ShouldEqual, 1)
			So(vods.Vods[0], ShouldResemble, internalUpload)
		})
		Convey("when PublicGetVodsByIDs fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetVodsByIDs", ctx, mock.Anything, (*vinyl.GetVodParams)(nil), mock.Anything).Return(nil, vinylErr)
			_, err := backend.PublicGetVodsByIDs(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
