package backend

import (
	"strconv"
	"strings"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// PublicGetVodsByUser should make an underlying call to vinyl
func (b *backendImpl) PublicGetVodsByUser(ctx context.Context, request *models.PublicGetVodsByUserRequest) (*models.VodsResponse, error) {
	b.stats.Inc(publicGetVodsByUserAttemptStatStr, 1, 1.0)

	userIDStr := strconv.FormatInt(request.ChannelID, 10)
	getUserInput := vinyl.GetVodsByUserInput{
		BroadcastType:  strings.Join(request.BroadcastTypes, ","),
		Language:       request.Language,
		Status:         request.Status,
		Sort:           request.Sort,
		Limit:          int(request.Limit),
		Offset:         int(request.Offset),
		RecordedAfter:  request.RecordedAfter,
		RecordedBefore: request.RecordedBefore,
	}
	vinylVods, err := b.vinyl.GetVodsByUser(ctx, userIDStr, getUserInput, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods.Vods), nil
}
