package backend

import (
	"strconv"
	"strings"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// PublicGetVodsByUsers should make an underlying call to vinyl
func (b *backendImpl) PublicGetVodsByUsers(ctx context.Context, request *models.PublicGetVodsByUsersRequest) (*models.VodsResponse, error) {
	b.stats.Inc(publicGetVodsByUsersAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.ChannelIDs))
	for i, id := range request.ChannelIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	followedInput := vinyl.FollowedInput{
		BroadcastType: strings.Join(request.BroadcastTypes, ","),
		Language:      request.Language,
		Sort:          request.Sort,
		Limit:         int(request.Limit),
		Offset:        int(request.Offset),
	}
	vinylVods, err := b.vinyl.Followed(ctx, ids, followedInput, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
