package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// ResolveTrackAppeal should make an underlying call to vinyl
func (b *backendImpl) ResolveTrackAppeal(ctx context.Context, request *models.ResolveTrackAppealRequest) error {
	b.stats.Inc(resolveTrackAppealAttemptStatStr, 1, 1.0)

	err := b.vinyl.ResolveTrackAppeal(ctx, strconv.FormatInt(request.TrackAppealID, 10), request.Action, nil)
	return b.ErrorHandle(err)
}
