package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestResolveTrackAppeal(t *testing.T) {
	Convey("when calling ResolveTrackAppeal", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ResolveTrackAppealRequest{
			TrackAppealID: 1234,
			Action:        "resolve",
		}

		Convey("when ResolveTrackAppeal succeeds", func() {
			mocks.vinyl.On("ResolveTrackAppeal", ctx, mock.Anything, mock.Anything, mock.Anything).Return(nil)
			err := backend.ResolveTrackAppeal(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when ResolveTrackAppeal fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("ResolveTrackAppeal", ctx, mock.Anything, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.ResolveTrackAppeal(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
