package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// ResolveVodAppeal should make an underlying call to vinyl
func (b *backendImpl) ResolveVodAppeal(ctx context.Context, request *models.ResolveVodAppealRequest) error {
	b.stats.Inc(resolveVodAppealAttemptStatStr, 1, 1.0)

	err := b.vinyl.ResolveVodAppeal(ctx, strconv.FormatInt(request.VodAppealID, 10), nil)
	return b.ErrorHandle(err)
}
