package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestResolveVodAppeal(t *testing.T) {
	Convey("when calling ResolveVodAppeal", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ResolveVodAppealRequest{
			VodAppealID: 1234,
		}

		Convey("when ResolveVodAppeal succeeds", func() {
			mocks.vinyl.On("ResolveVodAppeal", ctx, mock.Anything, mock.Anything).Return(nil)
			err := backend.ResolveVodAppeal(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when ResolveVodAppeal fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("ResolveVodAppeal", ctx, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.ResolveVodAppeal(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
