package backend

import (
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/vinyl"
	"golang.org/x/net/context"
)

// SetViewcounts should make an underlying call to vinyl
func (b *backendImpl) SetViewcounts(ctx context.Context, request *models.SetViewcountsRequest) error {
	b.stats.Inc(setViewcountsAttemptStatStr, 1, 1.0)

	viewcounts := make([]vinyl.SetViewcountsUpdate, len(request.Viewcounts))
	for i, viewcount := range request.Viewcounts {
		viewcounts[i] = vinyl.SetViewcountsUpdate{
			VodID: viewcount.VodID,
			Count: viewcount.Count,
		}
	}
	viewcountsUpdate := &vinyl.SetViewcountsInput{
		Viewcounts: viewcounts,
	}
	err := b.vinyl.SetViewcounts(ctx, viewcountsUpdate, nil)
	return b.ErrorHandle(err)
}
