package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestSetViewcounts(t *testing.T) {
	Convey("when calling SetViewcounts", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.SetViewcountsRequest{
			Viewcounts: []models.ViewcountsUpdate{
				models.ViewcountsUpdate{
					VodID: testdata.VodID1,
					Count: 5,
				},
			},
		}

		Convey("when SetViewcounts succeeds", func() {
			mocks.vinyl.On("SetViewcounts", ctx, mock.Anything, mock.Anything).Return(nil)
			err := backend.SetViewcounts(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when SetViewcounts fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("SetViewcounts", ctx, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.SetViewcounts(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
