package backend

import (
	"strconv"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// SoftDeleteVods should make an underlying call to vinyl
func (b *backendImpl) SoftDeleteVods(ctx context.Context, request *models.SoftDeleteVodsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(softDeleteVodsAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	deleteVodInput := vinyl.DeleteVodsInput{
		VodIDs:      ids,
		Destructive: false,
	}
	vinylVods, err := b.vinyl.DeleteVods(ctx, deleteVodInput, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
