package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// SoftDeleteVodsInInterval should make an underlying call to vinyl
func (b *backendImpl) SoftDeleteVodsInInterval(ctx context.Context, request *models.SoftDeleteVodsInIntervalRequest) error {
	b.stats.Inc(softDeleteVodsInIntervalAttemptStatStr, 1, 1.0)

	err := b.vinyl.SoftDeleteVodsInInterval(ctx, strconv.FormatInt(request.StartTimeUnixSeconds, 10), strconv.FormatInt(request.EndTimeUnixSeconds, 10), nil)
	return b.ErrorHandle(err)
}
