package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestSoftDeleteVodsInInterval(t *testing.T) {
	Convey("when calling SoftDeleteVodsInInterval", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.SoftDeleteVodsInIntervalRequest{
			StartTimeUnixSeconds: 100,
			EndTimeUnixSeconds:   500,
		}

		Convey("when SoftDeleteVodsInInterval succeeds", func() {
			mocks.vinyl.On("SoftDeleteVodsInInterval", ctx, mock.Anything, mock.Anything, mock.Anything).Return(nil)
			err := backend.SoftDeleteVodsInInterval(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when SoftDeleteVodsInInterval fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("SoftDeleteVodsInInterval", ctx, mock.Anything, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.SoftDeleteVodsInInterval(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
