package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// UndeleteVods should make an underlying call to vinyl
func (b *backendImpl) UndeleteVods(ctx context.Context, request *models.UndeleteVodsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(undeleteVodsAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	vinylVods, err := b.vinyl.UndeleteVods(ctx, ids, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
