package backend

import (
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// UpdateAudibleMagicResponses should make an underlying call to vinyl
func (b *backendImpl) UpdateAudibleMagicResponses(ctx context.Context, request *models.UpdateAudibleMagicResponsesRequest) (*models.AudibleMagicResponsesResponse, error) {
	b.stats.Inc(updateAudibleMagicResponsesAttemptStatStr, 1, 1.0)

	audibleMagicResponses, err := b.vinyl.UpdateAMRs(ctx, converters.ConvertInternalToVinylUpdateAudibleMagicResponse(request), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylAudibleMagicResponses(audibleMagicResponses), nil
}
