package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestUpdateAudibleMagicResponses(t *testing.T) {
	Convey("when calling UpdateAudibleMagicResponses", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.UpdateAudibleMagicResponsesRequest{
			UpdateAudibleMagicResponses: []models.UpdateAudibleMagicResponseRequest{
				models.UpdateAudibleMagicResponseRequest{
					Title: utils.StrPtr("title"),
				},
			},
		}

		Convey("when UpdateAudibleMagicResponses succeeds", func() {
			audibleMagicResponses := testdata.VinylAudibleMagicResponses()
			mocks.vinyl.On("UpdateAMRs", mock.Anything, mock.Anything, mock.Anything).Return(audibleMagicResponses, nil)
			thumbnailsResp, err := backend.UpdateAudibleMagicResponses(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when UpdateAudibleMagicResponses fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("UpdateAMRs", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.UpdateAudibleMagicResponses(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
