package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// UpdateManifest should make an underlying call to vinyl
func (b *backendImpl) UpdateManifest(ctx context.Context, request *models.UpdateManifestRequest) error {
	b.stats.Inc(updateManifestAttemptStatStr, 1, 1.0)

	updateManifestInput := &vinyl.UpdateVodInput{
		Manifest: &request.NewManifest,
	}
	_, err := b.vinyl.UpdateVod(ctx, strconv.FormatInt(request.VodID, 10), updateManifestInput, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	return b.ErrorHandle(err)
}
