package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestUpdateManifest(t *testing.T) {
	Convey("when calling UpdateManifest", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.UpdateManifestRequest{
			VodID:       testdata.VodID1,
			OldManifest: "old",
			NewManifest: "new",
		}

		Convey("when UpdateManifest succeeds", func() {
			mocks.vinyl.On("UpdateVod", ctx, mock.Anything, mock.Anything, mock.Anything).Return(&vinyl.Vod{}, nil)
			err := backend.UpdateManifest(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when UpdateManifest fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("UpdateVod", ctx, mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			err := backend.UpdateManifest(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
