package backend

import (
	"strconv"
	"strings"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// YoutubeExport should make an underlying call to vinyl
func (b *backendImpl) YoutubeExport(ctx context.Context, request *models.YoutubeExportRequest) error {
	b.stats.Inc(youtubeExportAttemptStatStr, 1, 1.0)

	youtubeExportInput := vinyl.YoutubeExportInput{
		VodID:       strconv.FormatInt(request.VodID, 10),
		Title:       request.Title,
		Description: request.Description,
		TagList:     strings.Join(request.TagList, ","),
		Private:     request.Private,
		DoSplit:     request.DoSplit,
	}
	err := b.vinyl.YoutubeExport(ctx, youtubeExportInput, nil)
	return b.ErrorHandle(err)
}
