package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestYoutubeExport(t *testing.T) {
	Convey("when calling YoutubeExport", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.YoutubeExportRequest{
			VodID:       testdata.VodID1,
			Title:       "title",
			Description: "description",
			TagList:     []string{"tags"},
			Private:     true,
			DoSplit:     true,
		}

		Convey("when YoutubeExport succeeds", func() {
			mocks.vinyl.On("YoutubeExport", ctx, mock.Anything, mock.Anything).Return(nil)
			err := backend.YoutubeExport(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when YoutubeExport fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("YoutubeExport", ctx, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.YoutubeExport(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
