package models

import "time"

// ShowFormat is the show format information
type ShowFormat struct {
	PlaylistPreference int64   `json:"playlist_preference"`
	DisplayName        string  `json:"display_name"`
	Bitrate            int64   `json:"bitrate"`
	Fps                float64 `json:"fps"`
	MaxIdrInterval     int64   `json:"max_idr_interval"`
	Codecs             string  `json:"codecs"`
	Resolution         string  `json:"resolution"`
}

// Thumbnail is the thumbnail information
type Thumbnail struct {
	Path   string   `json:"path"`
	Offset *float64 `json:"offset"`
}

// ThumbnailTemplate is the thumbnail template information
type ThumbnailTemplate struct {
	Offset float64 `json:"offset"`
	Path   string  `json:"path"`
	Type   string  `json:"type"`
	URL    string  `json:"url"`
}

// AudibleMagicResponse is the audible magic response information
type AudibleMagicResponse struct {
	AudibleMagicResponseID int64      `json:"audible_magic_response_id"`
	VodID                  int64      `json:"vod_id"`
	Title                  string     `json:"title"`
	Performer              string     `json:"performer"`
	Genre                  string     `json:"genre"`
	Artist                 string     `json:"artist"`
	AlbumTitle             string     `json:"album_title"`
	Song                   string     `json:"song"`
	Isrc                   string     `json:"isrc"`
	IsMatch                bool       `json:"is_match"`
	MatchOffsetSeconds     *int64     `json:"match_offset_seconds"`
	MatchDurationSeconds   *int64     `json:"match_duration_seconds"`
	ScanOffsetSeconds      *int64     `json:"scan_offset_seconds"`
	ScanDurationSeconds    *int64     `json:"scan_duration_seconds"`
	MuteOffsetSeconds      *int64     `json:"mute_offset_seconds"`
	MuteDurationSeconds    *int64     `json:"mute_duration_seconds"`
	AudibleMagicItemID     string     `json:"audible_magic_item_id"`
	CreatedAt              time.Time  `json:"create_at"`
	UpdatedAt              time.Time  `json:"updated_at"`
	SongLength             int64      `json:"song_length"`
	UnmutedAt              *time.Time `json:"unmuted_at"`
}

// VodMutedSegment is the vod muted segment information
type VodMutedSegment struct {
	Offset   int64 `json:"offset"`
	Duration int64 `json:"duration"`
}

// VodAppeal is the vod appeal information
type VodAppeal struct {
	VodAppealID    int64      `json:"vod_appeal_id"`
	ResolvedAt     *time.Time `json:"resolved_at"`
	CreatedAt      time.Time  `json:"created_at"`
	UpdatedAt      time.Time  `json:"updated_at"`
	VodID          int64      `json:"vod_id"`
	Priority       bool       `json:"priority"`
	FullName       string     `json:"full_name"`
	StreetAddress1 string     `json:"street_address_1"`
	StreetAddress2 string     `json:"street_address_2"`
	City           string     `json:"city"`
	State          string     `json:"state"`
	Zipcode        string     `json:"zipcode"`
	Country        string     `json:"country"`
}

// TrackAppeal is the track appeal information
type TrackAppeal struct {
	TrackAppealID          int64      `json:"track_appeal_id"`
	AudibleMagicResponseID int64      `json:"audible_magic_response_id"`
	VodAppealID            int64      `json:"vod_appeal_id"`
	Reason                 string     `json:"reason"`
	CreatedAt              time.Time  `json:"created_at"`
	UpdatedAt              time.Time  `json:"updated_at"`
	ResolvedAt             *time.Time `json:"resolved_at"`
}

// VodNotificationSetting is the vod notification setting information
type VodNotificationSetting struct {
	ID         int64      `json:"id"`
	VodID      int64      `json:"vod_id"`
	Type       string     `json:"type"`
	CustomText *string    `json:"custom_text"`
	Enabled    bool       `json:"enabled"`
	SentAt     *time.Time `json:"sent_at"`
	CreatedAt  time.Time  `json:"created_at"`
	UpdatedAt  time.Time  `json:"updated_at"`
}

// VodNotificationSettingsMap is the vod notification settings map information
type VodNotificationSettingsMap struct {
	Email       VodNotificationSetting `json:"email"`
	ChannelFeed VodNotificationSetting `json:"channel_feed"`
}

// Vod is the vod information
type Vod struct {
	BroadcastID          int64                      `json:"broadcast_id"`
	BroadcastType        string                     `json:"broadcast_type"`
	BroadcasterSoftware  *string                    `json:"broadcaster_software"`
	Communities          []string                   `json:"communities"`
	CreatedAt            time.Time                  `json:"created_at"`
	CreatedBy            *int64                     `json:"created_by"`
	DeleteAt             *time.Time                 `json:"delete_at"`
	Deleted              *bool                      `json:"deleted"`
	Description          *string                    `json:"description"`
	DescriptionHTML      *string                    `json:"description_html"`
	Duration             int64                      `json:"duration"`
	Fps                  map[string]float64         `json:"fps"`
	Game                 *string                    `json:"game"`
	ID                   int64                      `json:"id"`
	Language             *string                    `json:"language"`
	Manifest             *string                    `json:"manifest"`
	Offset               int64                      `json:"offset"`
	Origin               *string                    `json:"origin"`
	OwnerID              int64                      `json:"owner_id"`
	Resolutions          map[string]string          `json:"resolutions"`
	SourceArchiveID      *int64                     `json:"source_archive_id"`
	StartedOn            time.Time                  `json:"started_on"`
	Status               string                     `json:"status"`
	TagList              []string                   `json:"tag_list"`
	Title                *string                    `json:"title"`
	TotalLength          int64                      `json:"total_length"`
	UpdatedAt            time.Time                  `json:"updated_at"`
	URI                  string                     `json:"uri"`
	Viewable             string                     `json:"viewable"`
	ViewableAt           *time.Time                 `json:"viewable_at"`
	Views                int64                      `json:"views"`
	PublishedAt          *time.Time                 `json:"published_at"`
	IncrementViewURL     string                     `json:"increment_view_url"`
	Qualities            []string                   `json:"qualities"`
	PreviewTemplate      string                     `json:"preview_template"`
	ShowFormats          map[string]ShowFormat      `json:"show_formats"`
	ThumbnailTemplates   []ThumbnailTemplate        `json:"thumbnail_templates"`
	Thumbnails           []Thumbnail                `json:"thumbnails"`
	SeekPreviewsURL      string                     `json:"seek_previews_url"`
	AnimatedPreviewURL   string                     `json:"animated_preview_url"`
	Path                 string                     `json:"path"`
	URL                  string                     `json:"url"`
	NotificationsSetting VodNotificationSettingsMap `json:"notifications_setting"`
	HandwaveLatencyMS    *int64                     `json:"handwave_latency_ms"`
	Failure              *CreateErrorResponse       `json:"failure"`
}

// VodsResponse is the vod response information
type VodsResponse struct {
	Vods []*Vod `json:"vods"`
}

// VodMuteInfoResponse is the vod mute info response information
type VodMuteInfoResponse struct {
	ID                    int64                  `json:"id"`
	AudibleMagicResponses []AudibleMagicResponse `json:"audible_magic_responses"`
	MutedSegments         []VodMutedSegment      `json:"muted_segments"`
	VodAppeal             VodAppeal              `json:"vod_appeal"`
	TrackAppeals          []TrackAppeal          `json:"track_appeals"`
	IsMuted               *bool                  `json:"is_muted"`
	CanCreateAppeal       *bool                  `json:"can_create_appeal"`
	ViewOnlyAppeal        *bool                  `json:"view_only_appeal"`
	HasPendingAppeal      *bool                  `json:"has_pending_appeal"`
}

// PublicVodAggregationsByIDsResponse is the vod mute info response information
type PublicVodAggregationsByIDsResponse struct {
	TotalCount    int64 `json:"total_count"`
	TotalDuration int64 `json:"total_duration"`
}

// VodPopularityResponse is the vod popularity response information
type VodPopularityResponse struct {
	Popular bool `json:"popular"`
}

// CreateErrorResponse is the create error response information
type CreateErrorResponse struct {
	VodID        int64     `json:"vod_id"`
	ErrorCode    string    `json:"error_code"`
	ErrorMessage string    `json:"error_message"`
	CreatedAt    time.Time `json:"created_at"`
}

// CreateThumbnailsResponse is the create thumbnails response information
type CreateThumbnailsResponse struct {
	Thumbnails []Thumbnail `json:"thumbnails"`
}

// CreateCustomThumbnailUploadRequestResponse is the create custom thumbnail upload request response information
type CreateCustomThumbnailUploadRequestResponse struct {
	URL      string `json:"url"`
	UploadID string `json:"upload_id"`
}

// UserVodPropertiesResponse is the user vod properties response information
type UserVodPropertiesResponse struct {
	ChannelID                int64     `json:"channel_id"`
	VodStorageDays           int64     `json:"vod_storage_days"`
	SaveVodsForever          bool      `json:"save_vods_forever"`
	CanUploadVod             bool      `json:"can_upload_vod"`
	YoutubeExportingDisabled bool      `json:"youtube_exporting_disabled"`
	SkipUploadModeration     bool      `json:"skip_upload_moderation"`
	SkipMuting               bool      `json:"skip_muting"`
	CanUploadUnlimited       bool      `json:"can_upload_unlimited"`
	CreatedAt                time.Time `json:"created_at"`
	UpdatedAt                time.Time `json:"updated_at"`
}

// UserVideoPrivacyPropertiesResponse is the user video privacy properties response information
type UserVideoPrivacyPropertiesResponse struct {
	ChannelID           int64     `json:"channel_id"`
	HideArchives        bool      `json:"hide_archives"`
	HideArchivesEnabled bool      `json:"hide_archives_enabled"`
	CreatedAt           time.Time `json:"created_at"`
	UpdatedAt           time.Time `json:"updated_at"`
}

// VodAppealsResponse is the vod appeals response information
type VodAppealsResponse struct {
	TotalCount int64       `json:"total_count"`
	Appeals    []VodAppeal `json:"appeals"`
}

// AudibleMagicResponsesResponse is the audible magic responses response information
type AudibleMagicResponsesResponse struct {
	AudibleMagicResponses []AudibleMagicResponse `json:"audible_magic_responses"`
}
