package models

import (
	"time"
)

// CreateUploadRequest is the create upload request
type CreateUploadRequest struct {
	BroadcastType string     `json:"broadcast_type"`
	BroadcastID   int64      `json:"broadcast_id"`
	OwnerID       int64      `json:"owner_id"`
	Description   string     `json:"description"`
	Duration      int64      `json:"duration"`
	URI           string     `json:"uri"`
	Manifest      string     `json:"manifest"`
	Title         string     `json:"title"`
	Game          string     `json:"game"`
	Communities   []string   `json:"communities"`
	Language      string     `json:"language"`
	TagList       []string   `json:"tag_list"`
	Viewable      string     `json:"viewable"`
	ViewableAt    *time.Time `json:"viewable_at"`
}

// CreateArchiveRequest is the create archive request
type CreateArchiveRequest struct {
	BroadcastID         int64      `json:"broadcast_id"`
	BroadcasterSoftware string     `json:"broadcaster_software"`
	RecordedOn          *time.Time `json:"recorded_on"`
	Title               string     `json:"title"`
	ChannelID           int64      `json:"channel_id"`
	Duration            int64      `json:"duration"`
	URI                 string     `json:"uri"`
	Manifest            string     `json:"manifest"`
	Deleted             bool       `json:"deleted"`
	HandwaveLatencyMS   int64      `json:"handwave_latency_ms"`
}

// InternalCreateHighlightRequest is the create highlight request
type InternalCreateHighlightRequest struct {
	SourceArchiveID int64                 `json:"source_archive_id"`
	OwnerID         string                `json:"owner_id"`
	URI             string                `json:"uri"`
	BroadcastID     int64                 `json:"broadcast_id"`
	ShowFormats     map[string]ShowFormat `json:"show_formats"`
	Title           string                `json:"title"`
	Duration        int64                 `json:"duration"`
}

// ManagerCreateHighlightRequest is the create highlight request
type ManagerCreateHighlightRequest struct {
	VodID        int64    `json:"vod_id"`
	Description  string   `json:"description"`
	Game         string   `json:"game"`
	Title        string   `json:"title"`
	Language     string   `json:"language"`
	StartSeconds int64    `json:"start_seconds"`
	EndSeconds   int64    `json:"end_seconds"`
	TagList      []string `json:"tag_list"`
	CreatedBy    int64    `json:"created_by"`
	UserID       int64    `json:"user_id"`
}

// PublicGetVodByIDRequest is the public get vod by id request
type PublicGetVodByIDRequest struct {
	VodID int64 `json:"vod_id"`
}

// InternalGetVodByIDRequest is the internal get vod by id request
type InternalGetVodByIDRequest struct {
	VodID int64 `json:"vod_id"`
}

// ManagerInternalGetVodByIDRequest is the manager internal get vod by id request
type ManagerInternalGetVodByIDRequest struct {
	VodID  int64 `json:"vod_id"`
	UserID int64 `json:"user_id"`
}

// ManagerGetVodMuteInfoRequest is the manager get vod mute info request
type ManagerGetVodMuteInfoRequest struct {
	VodID  int64 `json:"vod_id"`
	UserID int64 `json:"user_id"`
}

// InternalGetVodMuteInfoRequest is the internal get vod mute info request
type InternalGetVodMuteInfoRequest struct {
	VodID int64 `json:"vod_id"`
}

// ManagerGetVodMuteInfosRequest is the manager get vods mute info request
type ManagerGetVodMuteInfosRequest struct {
	VodIDs []int64 `json:"vod_ids"`
	UserID int64   `json:"user_id"`
}

// GetVodByIDIncludeBannedUsersRequest is the get vod by id include banned users request
type GetVodByIDIncludeBannedUsersRequest struct {
	VodID int64 `json:"vod_id"`
}

// ManagerGetVodByIDRequest is the manager get vod by id request
type ManagerGetVodByIDRequest struct {
	VodID  int64 `json:"vod_id"`
	UserID int64 `json:"user_id"`
}

// ManagerSearchVodsRequest is the manager search vods request
type ManagerSearchVodsRequest struct {
	ChannelID int64  `json:"channel_id"`
	Search    string `json:"search"`
	Limit     int64  `json:"limit"`
	Offset    int64  `json:"offset"`
	UserID    int64  `json:"user_id"`
}

// PublicGetVodsByUserRequest is the public get vods by user request
type PublicGetVodsByUserRequest struct {
	ChannelID      int64      `json:"channel_id"`
	BroadcastTypes []string   `json:"broadcast_types"`
	Language       string     `json:"language"`
	Status         string     `json:"status"`
	Sort           string     `json:"sort"`
	Limit          int64      `json:"limit"`
	Offset         int64      `json:"offset"`
	RecordedAfter  *time.Time `json:"recorded_after"`
	RecordedBefore *time.Time `json:"recorded_before"`
}

// ManagerInternalGetVodsByUserRequest is the manager internal get vods by user request
type ManagerInternalGetVodsByUserRequest struct {
	ChannelID       int64      `json:"channel_id"`
	BroadcastTypes  []string   `json:"broadcast_types"`
	Language        string     `json:"language"`
	Status          string     `json:"status"`
	Sort            string     `json:"sort"`
	Limit           int64      `json:"limit"`
	Offset          int64      `json:"offset"`
	UserID          int64      `json:"user_id"`
	PublishedWithin string     `json:"published_within"`
	RecordedAfter   *time.Time `json:"recorded_after"`
	RecordedBefore  *time.Time `json:"recorded_before"`
}

// ManagerGetVodsByUserIncludeBannedUsersRequest is the manager get vods by user include banned users request
type ManagerGetVodsByUserIncludeBannedUsersRequest struct {
	ChannelID      int64    `json:"channel_id"`
	BroadcastTypes []string `json:"broadcast_types"`
	Language       string   `json:"language"`
	Status         string   `json:"status"`
	Sort           string   `json:"sort"`
	Limit          int64    `json:"limit"`
	Offset         int64    `json:"offset"`
	UserID         int64    `json:"user_id"`
}

// InternalGetVodsByBroadcastIDsRequest is the internal get vods by broadcast ids request
type InternalGetVodsByBroadcastIDsRequest struct {
	BroadcastIDs []string `json:"broadcast_ids"`
}

// PublicGetVodsByIDsRequest is the public get vods by ids request
type PublicGetVodsByIDsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// InternalGetVodsByIDsRequest is the get vods by ids request
type InternalGetVodsByIDsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// GetVodsByIDsIncludeBannedUsersRequest is the get vods by ids include banned users request
type GetVodsByIDsIncludeBannedUsersRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// PublicGetVodsByUsersRequest is the public get vods by users request
type PublicGetVodsByUsersRequest struct {
	ChannelIDs     []int64  `json:"channel_ids"`
	BroadcastTypes []string `json:"broadcast_types"`
	Language       string   `json:"language"`
	Status         string   `json:"status"`
	Sort           string   `json:"sort"`
	Limit          int64    `json:"limit"`
	Offset         int64    `json:"offset"`
}

// GetTopVodsRequest is the get top vods request
type GetTopVodsRequest struct {
	BroadcastTypes []string `json:"broadcast_types"`
	Language       string   `json:"language"`
	Game           string   `json:"game"`
	Period         string   `json:"period"`
	Sort           string   `json:"sort"`
	Limit          int64    `json:"limit"`
	Offset         int64    `json:"offset"`
}

// ManagerUpdateVodRequest is the update vod request
type ManagerUpdateVodRequest struct {
	VodID         int64                 `json:"vod_id"`
	BroadcastType string                `json:"broadcast_type"`
	Description   *string               `json:"description"`
	Game          *string               `json:"game"`
	Communities   []string              `json:" communities"`
	Language      *string               `json:"language"`
	TagList       []string              `json:"tag_list"`
	ThumbnailPath *string               `json:"thumbnail_path"`
	Title         *string               `json:"title"`
	Viewable      string                `json:"viewable"`
	ViewableAt    *time.Time            `json:"viewable_at"`
	BroadcastID   *int64                `json:"broadcast_id"`
	Offset        *int64                `json:"offset"`
	Status        string                `json:"status"`
	Duration      *int64                `json:"duration"`
	ShowFormats   map[string]ShowFormat `json:"show_formats"`
	UserID        int64                 `json:"user_id"`
	URI           *string               `json:"uri"`
}

// UndeleteVodsRequest is the undelete vods request
type UndeleteVodsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// SoftDeleteVodsRequest is the soft delete vods request
type SoftDeleteVodsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// InternalVodRemoveRecordsRequest is the internal vod remove records request
type InternalVodRemoveRecordsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// HardDeleteVodsRequest is the hard delete vods request
type HardDeleteVodsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// SoftDeleteVodsInIntervalRequest is the soft delete vods in interval request
type SoftDeleteVodsInIntervalRequest struct {
	StartTimeUnixSeconds int64 `json:"start_time_unix_seconds"`
	EndTimeUnixSeconds   int64 `json:"end_time_unix_seconds"`
}

// ManagerSoftDeleteVodsRequest is the auth soft delete vods request
type ManagerSoftDeleteVodsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
	UserID int64   `json:"user_id"`
}

// YoutubeExportRequest is the youtube export request
type YoutubeExportRequest struct {
	VodID       int64    `json:"vod_id"`
	Title       string   `json:"title"`
	Description string   `json:"description"`
	TagList     []string `json:"tag_list"`
	Private     bool     `json:"private"`
	DoSplit     bool     `json:"do_split"`
}

// FinalizeUploadRequest is the finalize upload request
type FinalizeUploadRequest struct {
	VodID int64 `json:"vod_id"`
}

// UpdateManifestRequest is the update manifest request
type UpdateManifestRequest struct {
	VodID       int64  `json:"vod_id"`
	OldManifest string `json:"old_manifest"`
	NewManifest string `json:"new_manifest"`
}

// ViewcountsUpdate is the view counts update request
type ViewcountsUpdate struct {
	VodID int64 `json:"vod_id"`
	Count int64 `json:"count"`
}

// SetViewcountsRequest is the set view counts request
type SetViewcountsRequest struct {
	Viewcounts []ViewcountsUpdate `json:"view_counts"`
}

// GetPublicVodAggregationsByIDsRequest is the get public vod aggregations by id request
type GetPublicVodAggregationsByIDsRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// GetVodPopularityRequest is the get vod popularity request
type GetVodPopularityRequest struct {
	VodID int64 `json:"vod_id"`
}

// CreateErrorRequest is the create error request
type CreateErrorRequest struct {
	VodID        int64  `json:"vod_id"`
	ErrorCode    string `json:"error_code"`
	ErrorMessage string `json:"error_message"`
}

// ThumbnailRequest is the thumbnail request
type ThumbnailRequest struct {
	Path   string   `json:"path"`
	Offset *float64 `json:"offset"`
}

// CreateThumbnailsRequest is the create thumbnail request
type CreateThumbnailsRequest struct {
	VodID      int64              `json:"vod_id"`
	Thumbnails []ThumbnailRequest `json:"thumbnails"`
}

// ManagerCreateCustomThumbnailUploadRequestRequest is the create custom thumbnail upload request request
type ManagerCreateCustomThumbnailUploadRequestRequest struct {
	VodID  int64 `json:"vod_id"`
	CropX  int64 `json:"crop_x"`
	CropY  int64 `json:"crop_y"`
	CropW  int64 `json:"crop_w"`
	CropH  int64 `json:"crop_h"`
	UserID int64 `json:"user_id"`
}

// ManagerDeleteThumbnailsRequest is the auth delete thumbnails request
type ManagerDeleteThumbnailsRequest struct {
	VodID  int64  `json:"vod_id"`
	Path   string `json:"path"`
	UserID int64  `json:"user_id"`
}

// DeleteThumbnailsRequest is the delete thumbnails request
type DeleteThumbnailsRequest struct {
	VodID int64 `json:"vod_id"`
}

// ManagerGetUserVodPropertiesRequest is the get user vod properties request
type ManagerGetUserVodPropertiesRequest struct {
	ChannelID int64 `json:"channel_id"`
	UserID    int64 `json:"user_id"`
}

// ManagerUpdateUserVodPropertiesRequest is the update user vod properties request
type ManagerUpdateUserVodPropertiesRequest struct {
	ChannelID                int64  `json:"channel_id"`
	UserID                   int64  `json:"user_id"`
	SaveVodsForever          *bool  `json:"save_vods_forever"`
	VodStorageDays           *int64 `json:"vod_storage_days"`
	CanUploadVod             *bool  `json:"can_upload_vod"`
	YoutubeExportingDisabled *bool  `json:"youtube_exporting_disabled"`
	SkipUploadModeration     *bool  `json:"skip_upload_moderation"`
	SkipMuting               *bool  `json:"skip_muting"`
	CanUploadUnlimited       *bool  `json:"can_upload_unlimited"`
}

// ManagerGetUserVideoPrivacyPropertiesRequest is the get user video privacy properties request
type ManagerGetUserVideoPrivacyPropertiesRequest struct {
	ChannelID int64 `json:"channel_id"`
	UserID    int64 `json:"user_id"`
}

// ManagerUpdateUserVideoPrivacyPropertiesRequest is the set user video privacy properties request
type ManagerUpdateUserVideoPrivacyPropertiesRequest struct {
	ChannelID    int64 `json:"channel_id"`
	HideArchives bool  `json:"hide_archives"`
	UserID       int64 `json:"user_id"`
}

// TrackAppealRequest is the track appeal request
type TrackAppealRequest struct {
	AudibleMagicResponseID int64  `json:"audible_magic_response_id"`
	Reason                 string `json:"reason"`
}

// ManagerCreateVodAppealsRequest is the create appeals request
type ManagerCreateVodAppealsRequest struct {
	VodID          int64                `json:"vod_id"`
	City           string               `json:"city"`
	Country        string               `json:"country"`
	FullName       string               `json:"full_name"`
	State          string               `json:"state"`
	StreetAddress1 string               `json:"street_address1"`
	StreetAddress2 string               `json:"street_address2"`
	Zipcode        string               `json:"zipcode"`
	TrackAppeals   []TrackAppealRequest `json:"track_appeals"`
	UserID         int64                `json:"user_id"`
}

// GetVodAppealsRequest is the get vod appeals request
type GetVodAppealsRequest struct {
	Priority *bool  `json:"priority"`
	Resolved *bool  `json:"resolved"`
	Limit    int64  `json:"limit"`
	Offset   int64  `json:"offset"`
	VodID    int64  `json:"vod_id"`
	UserInfo string `json:"string"`
}

// ResolveTrackAppealRequest is the resolve track appeal request
type ResolveTrackAppealRequest struct {
	TrackAppealID int64  `json:"track_appeal_id"`
	Action        string `json:"action"`
}

// ResolveVodAppealRequest is the resolve vod appeal request
type ResolveVodAppealRequest struct {
	VodAppealID int64 `json:"vod_appeal_id"`
}

// CreateAudibleMagicResponseRequest is the create audible magic response request
type CreateAudibleMagicResponseRequest struct {
	VodID                int64  `json:"vod_id"`
	Title                string `json:"title"`
	Performer            string `json:"performer"`
	Genre                string `json:"genre"`
	Artist               string `json:"artist"`
	AlbumTitle           string `json:"album_title"`
	Song                 string `json:"song"`
	Isrc                 string `json:"isrc"`
	IsMatch              bool   `json:"is_match"`
	MatchOffsetSeconds   int64  `json:"match_offset_seconds"`
	MatchDurationSeconds int64  `json:"match_duration_seconds"`
	ScanOffsetSeconds    int64  `json:"scan_offset_seconds"`
	ScanDurationSeconds  int64  `json:"scan_duration_seconds"`
	MuteOffsetSeconds    int64  `json:"mute_offset_seconds"`
	MuteDurationSeconds  int64  `json:"mute_duration_seconds"`
	AudibleMagicItemID   string `json:"audible_magic_item_id"`
}

// CreateAudibleMagicResponsesRequest is the create audible magic responses request
type CreateAudibleMagicResponsesRequest struct {
	AudibleMagicResponses []CreateAudibleMagicResponseRequest `json:"audible_magic_responses"`
}

// GetAudibleMagicResponsesRequest is the get audible magic responses request
type GetAudibleMagicResponsesRequest struct {
	VodIDs []int64 `json:"vod_ids"`
}

// UpdateAudibleMagicResponseRequest is the update response request
type UpdateAudibleMagicResponseRequest struct {
	AudibleMagicResponseID int64   `json:"audible_magic_response_id"`
	Title                  *string `json:"title"`
	Performer              *string `json:"performer"`
	Genre                  *string `json:"genre"`
	Artist                 *string `json:"artist"`
	AlbumTitle             *string `json:"album_title"`
	Song                   *string `json:"song"`
	Isrc                   *string `json:"isrc"`
	IsMatch                bool    `json:"is_match"`
	MatchOffsetSeconds     *int64  `json:"match_offset_seconds"`
	MatchDurationSeconds   *int64  `json:"match_duration_seconds"`
	ScanOffsetSeconds      *int64  `json:"scan_offset_seconds"`
	ScanDurationSeconds    *int64  `json:"scan_duration_seconds"`
	MuteOffsetSeconds      *int64  `json:"mute_offset_seconds"`
	MuteDurationSeconds    *int64  `json:"mute_duration_seconds"`
	AudibleMagicItemID     *string `json:"audible_magic_item_id"`
}

// UpdateAudibleMagicResponsesRequest is the update responses request
type UpdateAudibleMagicResponsesRequest struct {
	UpdateAudibleMagicResponses []UpdateAudibleMagicResponseRequest `json:"update_audible_magic_responses"`
}
