package converters

import (
	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ConvertToInternalCreateAppeals converts CreateAppeals from internal representation to rpc
func ConvertToInternalCreateAppeals(r *rpc.ManagerCreateVodAppealsRequest) *models.ManagerCreateVodAppealsRequest {
	trackAppeals := make([]models.TrackAppealRequest, len(r.TrackAppeals))
	for i, trackAppeal := range r.TrackAppeals {
		trackAppeals[i] = models.TrackAppealRequest{
			AudibleMagicResponseID: utils.StrToInt64(trackAppeal.AudibleMagicResponseId),
			Reason:                 trackAppeal.Reason,
		}
	}
	return &models.ManagerCreateVodAppealsRequest{
		VodID:          utils.StrToInt64(r.VodId),
		City:           r.City,
		Country:        r.Country,
		FullName:       r.FullName,
		State:          r.State,
		StreetAddress1: r.StreetAddress1,
		StreetAddress2: r.StreetAddress2,
		Zipcode:        r.Zipcode,
		TrackAppeals:   trackAppeals,
		UserID:         utils.StrToInt64(r.UserId),
	}
}

// ConvertFromInternalAppealsResponse converts AppealsResponse map from internal representation to rpc
func ConvertFromInternalAppealsResponse(resp *models.VodAppealsResponse) *rpc.VodAppealsResponse {
	appeals := make([]*rpc.VodAppeal, len(resp.Appeals))
	for i, appeal := range resp.Appeals {
		appeals[i] = &rpc.VodAppeal{
			VodAppealId:    utils.Int64ToStr(appeal.VodAppealID),
			Priority:       appeal.Priority,
			VodId:          utils.Int64ToStr(appeal.VodID),
			City:           appeal.City,
			Country:        appeal.Country,
			FullName:       appeal.FullName,
			State:          appeal.State,
			StreetAddress1: appeal.StreetAddress1,
			StreetAddress2: appeal.StreetAddress2,
			Zipcode:        appeal.Zipcode,
			CreatedAt:      utils.ProtobufTimeAsTimestamp(&appeal.CreatedAt),
			UpdatedAt:      utils.ProtobufTimeAsTimestamp(&appeal.UpdatedAt),
			ResolvedAt:     utils.ProtobufTimeAsTimestamp(appeal.ResolvedAt),
		}
	}
	return &rpc.VodAppealsResponse{
		TotalCount: resp.TotalCount,
		Appeals:    appeals,
	}
}

// ConvertToInternalCreateAudibleMagicResponses converts CreateAudibleMagicResponses from internal representation to rpc
func ConvertToInternalCreateAudibleMagicResponses(r *rpc.CreateAudibleMagicResponsesRequest) *models.CreateAudibleMagicResponsesRequest {
	audibleMagicResponses := make([]models.CreateAudibleMagicResponseRequest, len(r.AudibleMagicResponses))
	for i, audibleMagicResponse := range r.AudibleMagicResponses {
		audibleMagicResponses[i] = models.CreateAudibleMagicResponseRequest{
			VodID:                utils.StrToInt64(audibleMagicResponse.VodId),
			Title:                audibleMagicResponse.Title,
			Performer:            audibleMagicResponse.Performer,
			Genre:                audibleMagicResponse.Genre,
			Artist:               audibleMagicResponse.Artist,
			AlbumTitle:           audibleMagicResponse.AlbumTitle,
			Song:                 audibleMagicResponse.Song,
			Isrc:                 audibleMagicResponse.Isrc,
			IsMatch:              audibleMagicResponse.IsMatch,
			MatchOffsetSeconds:   audibleMagicResponse.MatchOffsetSeconds,
			MatchDurationSeconds: audibleMagicResponse.MatchDurationSeconds,
			ScanOffsetSeconds:    audibleMagicResponse.ScanOffsetSeconds,
			ScanDurationSeconds:  audibleMagicResponse.ScanDurationSeconds,
			MuteOffsetSeconds:    audibleMagicResponse.MuteOffsetSeconds,
			MuteDurationSeconds:  audibleMagicResponse.MuteDurationSeconds,
			AudibleMagicItemID:   audibleMagicResponse.AudibleMagicItemId,
		}
	}
	return &models.CreateAudibleMagicResponsesRequest{
		AudibleMagicResponses: audibleMagicResponses,
	}
}

// ConvertToInternalUpdateAudibleMagicResponses converts UpdateAudibleMagicResponses from internal representation to rpc
func ConvertToInternalUpdateAudibleMagicResponses(r *rpc.UpdateAudibleMagicResponsesRequest) *models.UpdateAudibleMagicResponsesRequest {
	audibleMagicResponses := make([]models.UpdateAudibleMagicResponseRequest, len(r.UpdateAudibleMagicResponses))
	for i, audibleMagicResponse := range r.UpdateAudibleMagicResponses {
		audibleMagicResponses[i] = models.UpdateAudibleMagicResponseRequest{
			AudibleMagicResponseID: utils.StrToInt64(audibleMagicResponse.AudibleMagicResponseId),
			Title:                utils.FromProtobufStringValue(audibleMagicResponse.Title),
			Performer:            utils.FromProtobufStringValue(audibleMagicResponse.Performer),
			Genre:                utils.FromProtobufStringValue(audibleMagicResponse.Genre),
			Artist:               utils.FromProtobufStringValue(audibleMagicResponse.Artist),
			AlbumTitle:           utils.FromProtobufStringValue(audibleMagicResponse.AlbumTitle),
			Song:                 utils.FromProtobufStringValue(audibleMagicResponse.Song),
			Isrc:                 utils.FromProtobufStringValue(audibleMagicResponse.Isrc),
			IsMatch:              audibleMagicResponse.IsMatch,
			MatchOffsetSeconds:   utils.FromProtobufInt64Value(audibleMagicResponse.MatchOffsetSeconds),
			MatchDurationSeconds: utils.FromProtobufInt64Value(audibleMagicResponse.MatchDurationSeconds),
			ScanOffsetSeconds:    utils.FromProtobufInt64Value(audibleMagicResponse.ScanOffsetSeconds),
			ScanDurationSeconds:  utils.FromProtobufInt64Value(audibleMagicResponse.ScanDurationSeconds),
			MuteOffsetSeconds:    utils.FromProtobufInt64Value(audibleMagicResponse.MuteOffsetSeconds),
			MuteDurationSeconds:  utils.FromProtobufInt64Value(audibleMagicResponse.MuteDurationSeconds),
			AudibleMagicItemID:   utils.FromProtobufStringValue(audibleMagicResponse.AudibleMagicItemId),
		}
	}
	return &models.UpdateAudibleMagicResponsesRequest{
		UpdateAudibleMagicResponses: audibleMagicResponses,
	}
}

// ConvertFromInternalAudibleMagicResponses converts AudibleMagicResponses map from internal representation to rpc
func ConvertFromInternalAudibleMagicResponses(resp *models.AudibleMagicResponsesResponse) *rpc.AudibleMagicResponsesResponse {
	audibleMagicResponses := make([]*rpc.AudibleMagicResponse, len(resp.AudibleMagicResponses))
	for i, audibleMagicResponse := range resp.AudibleMagicResponses {
		audibleMagicResponses[i] = &rpc.AudibleMagicResponse{
			VodId:                utils.Int64ToStr(audibleMagicResponse.VodID),
			Title:                audibleMagicResponse.Title,
			Performer:            audibleMagicResponse.Performer,
			Genre:                audibleMagicResponse.Genre,
			Artist:               audibleMagicResponse.Artist,
			AlbumTitle:           audibleMagicResponse.AlbumTitle,
			Song:                 audibleMagicResponse.Song,
			Isrc:                 audibleMagicResponse.Isrc,
			IsMatch:              audibleMagicResponse.IsMatch,
			MatchOffsetSeconds:   utils.ProtobufInt64Value(audibleMagicResponse.MatchOffsetSeconds),
			MatchDurationSeconds: utils.ProtobufInt64Value(audibleMagicResponse.MatchDurationSeconds),
			ScanOffsetSeconds:    utils.ProtobufInt64Value(audibleMagicResponse.ScanOffsetSeconds),
			ScanDurationSeconds:  utils.ProtobufInt64Value(audibleMagicResponse.ScanDurationSeconds),
			MuteOffsetSeconds:    utils.ProtobufInt64Value(audibleMagicResponse.MuteOffsetSeconds),
			MuteDurationSeconds:  utils.ProtobufInt64Value(audibleMagicResponse.MuteDurationSeconds),
			AudibleMagicItemId:   audibleMagicResponse.AudibleMagicItemID,
		}
	}
	return &rpc.AudibleMagicResponsesResponse{
		AudibleMagicResponses: audibleMagicResponses,
	}
}
