package converters

import (
	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ConvertRPCCreateUploadRequest converts from RPC upload request to internal upload request
func ConvertRPCCreateUploadRequest(uploadRequest *rpc.CreateUploadRequest) *models.CreateUploadRequest {
	return &models.CreateUploadRequest{
		BroadcastType: rpc.ConvertVodType(uploadRequest.BroadcastType),
		BroadcastID:   utils.StrToInt64(uploadRequest.BroadcastId),
		OwnerID:       utils.StrToInt64(uploadRequest.OwnerId),
		Description:   uploadRequest.Description,
		Title:         uploadRequest.Title,
		Game:          uploadRequest.Game,
		Communities:   uploadRequest.Communities,
		Language:      uploadRequest.Language,
		TagList:       uploadRequest.TagList,
		Viewable:      rpc.ConvertVodViewable(uploadRequest.Viewable),
		ViewableAt:    utils.FromProtobufTimestampToTime(uploadRequest.ViewableAt),
	}
}
