package converters_test

import (
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	"code.justin.tv/vod/vodapi/internal/testdata"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	"github.com/stretchr/testify/assert"
)

func TestConvertRPCCreateUploadRequest(t *testing.T) {
	utils.StubTimeNow()
	uploadRequest := testdata.CreateUploadRequest()
	assert.Equal(t, &models.CreateUploadRequest{
		BroadcastType: "upload",
		BroadcastID:   1,
		OwnerID:       234210792,
		Description:   "Play Now ➜ https://putclokertv.com/tv/46896-the-originals/season-5/episode-10/\n\n♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥♥\n\nThe Originals final season,\nThe Originals new season,\nThe Originals season 5 cast,\nThe Originals 123movies season 5,\nThe Originals season 5 part 10,\nwatch The Originals online,\nThe Originals season 5 episode 10,\nThe Originals season 5,\nThe Originals season premiere,\nThe Originals watch online,\nThe Originals norsk,\nThe Originals season 5 ep 10,\nThe Originals 5x10,\nThe Originals sesong 5 episode 10,\nThe Originals season 5 norge,\nThe Originals sesong 5,\nThe Originals season 5 online free,\nThe Originals 05x010,\nThe Originals season 5 stream,\nThe Originals norge,\nThe Originals 5x10 full episode,\nThe Originals 5 sezon 10 bolum,\nThe Originals season 5 online free,\nThe Originals 5x10 full episode,\nThe Originals sesong 5 episode 10,\nThe Originals season 5 stream,\nThe Originals 5x10,\nThe Originals 05x010,\nThe Originals season 5 ep 10,\nThe Originals 5.sezon 10. bolum,\nThe Originals norsk,\nThe Originals norge,\nThe Originals season 5 norge,\nThe Originals sesong 5,",
		Title:         "The Originals (Se.05 Ep.10) Season 5 Episode 10 Full Watch",
		Game:          "League of Legends",
		Communities: []string{
			"136d5c6a-a7ed-4b6d-aedb-1deb08793157",
		},
		Language:   "en",
		TagList:    []string{""},
		Viewable:   "public",
		ViewableAt: utils.TimePtr(utils.Now()),
	}, converters.ConvertRPCCreateUploadRequest(uploadRequest))
}
