package converters

import (
	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// ConvertToShowFormatsRequest converts show formats to requests from rpc to update vod format
func ConvertToShowFormatsRequest(showFormats map[string]*rpc.ShowFormat) map[string]*rpc.ShowFormatRequest {
	result := make(map[string]*rpc.ShowFormatRequest, len(showFormats))
	for key, format := range showFormats {
		result[key] = &rpc.ShowFormatRequest{
			PlaylistPreference: format.PlaylistPreference,
			DisplayName:        format.DisplayName,
			Bitrate:            format.Bitrate,
			Fps:                format.Fps,
			MaxIdrInterval:     format.MaxIdrInterval,
			Codecs:             format.Codecs,
			Resolution:         format.Resolution,
		}
	}
	return result
}

// ConvertToInternalShowFormats converts ShowFormat map from internal representation to rpc
func ConvertToInternalShowFormats(showFormats map[string]*rpc.ShowFormatRequest) map[string]models.ShowFormat {
	result := make(map[string]models.ShowFormat, len(showFormats))
	for key, format := range showFormats {
		result[key] = models.ShowFormat{
			PlaylistPreference: format.PlaylistPreference,
			DisplayName:        format.DisplayName,
			Bitrate:            format.Bitrate,
			Fps:                format.Fps,
			MaxIdrInterval:     format.MaxIdrInterval,
			Codecs:             format.Codecs,
			Resolution:         format.Resolution,
		}
	}
	return result
}

// ConvertFromInternalShowFormats converts ShowFormat map from internal representation to rpc
func ConvertFromInternalShowFormats(showFormats map[string]models.ShowFormat) map[string]*rpc.ShowFormat {
	result := make(map[string]*rpc.ShowFormat, len(showFormats))
	for key, format := range showFormats {
		result[key] = &rpc.ShowFormat{
			PlaylistPreference: format.PlaylistPreference,
			DisplayName:        format.DisplayName,
			Bitrate:            format.Bitrate,
			Fps:                format.Fps,
			MaxIdrInterval:     format.MaxIdrInterval,
			Codecs:             format.Codecs,
			Resolution:         format.Resolution,
		}
	}
	return result
}
