package converters

import (
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestShowFormats(t *testing.T) {
	Convey("when using show formats convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting to show formats request", func() {
			input := map[string]*rpc.ShowFormat{
				"format": &rpc.ShowFormat{
					PlaylistPreference: 1,
					DisplayName:        "display",
					Bitrate:            2,
					Fps:                3.4,
					MaxIdrInterval:     5,
					Codecs:             "codecs",
					Resolution:         "resolution",
				},
			}
			output := map[string]*rpc.ShowFormatRequest{
				"format": &rpc.ShowFormatRequest{
					PlaylistPreference: input["format"].PlaylistPreference,
					DisplayName:        input["format"].DisplayName,
					Bitrate:            input["format"].Bitrate,
					Fps:                input["format"].Fps,
					MaxIdrInterval:     input["format"].MaxIdrInterval,
					Codecs:             input["format"].Codecs,
					Resolution:         input["format"].Resolution,
				},
			}
			So(output, ShouldResemble, ConvertToShowFormatsRequest(input))
		})
		Convey("when converting to internal show formats", func() {
			input := map[string]*rpc.ShowFormatRequest{
				"format": &rpc.ShowFormatRequest{
					PlaylistPreference: 1,
					DisplayName:        "display",
					Bitrate:            2,
					Fps:                3.4,
					MaxIdrInterval:     5,
					Codecs:             "codecs",
					Resolution:         "resolution",
				},
			}
			output := map[string]models.ShowFormat{
				"format": models.ShowFormat{
					PlaylistPreference: input["format"].PlaylistPreference,
					DisplayName:        input["format"].DisplayName,
					Bitrate:            input["format"].Bitrate,
					Fps:                input["format"].Fps,
					MaxIdrInterval:     input["format"].MaxIdrInterval,
					Codecs:             input["format"].Codecs,
					Resolution:         input["format"].Resolution,
				},
			}
			So(output, ShouldResemble, ConvertToInternalShowFormats(input))
		})
		Convey("when converting from internal show formats", func() {
			input := map[string]models.ShowFormat{
				"format": models.ShowFormat{
					PlaylistPreference: 1,
					DisplayName:        "display",
					Bitrate:            2,
					Fps:                3.4,
					MaxIdrInterval:     5,
					Codecs:             "codecs",
					Resolution:         "resolution",
				},
			}
			output := map[string]*rpc.ShowFormat{
				"format": &rpc.ShowFormat{
					PlaylistPreference: input["format"].PlaylistPreference,
					DisplayName:        input["format"].DisplayName,
					Bitrate:            input["format"].Bitrate,
					Fps:                input["format"].Fps,
					MaxIdrInterval:     input["format"].MaxIdrInterval,
					Codecs:             input["format"].Codecs,
					Resolution:         input["format"].Resolution,
				},
			}
			So(output, ShouldResemble, ConvertFromInternalShowFormats(input))
		})
	})
}
