package converters

import (
	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// ConvertInternalThumbnailTemplates converts ThumbnailTemplate array from internal representation to rpc
func ConvertInternalThumbnailTemplates(thumbnailTemplates []models.ThumbnailTemplate) []*rpc.ThumbnailTemplate {
	result := make([]*rpc.ThumbnailTemplate, len(thumbnailTemplates))
	for i, template := range thumbnailTemplates {
		result[i] = &rpc.ThumbnailTemplate{
			Offset: template.Offset,
			Path:   template.Path,
			Type:   rpc.ConvertInternalVodThumbnailType(template.Type),
			Url:    template.URL,
		}
	}
	return result
}
