package converters

import (
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestThumbnailTemplates(t *testing.T) {
	Convey("when using thumbnail templates convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting to internal thumbnail templates", func() {
			input := []models.ThumbnailTemplate{
				models.ThumbnailTemplate{
					Offset: 1.2,
					Path:   "path",
					Type:   "type",
					URL:    "url",
				},
			}
			output := []*rpc.ThumbnailTemplate{
				&rpc.ThumbnailTemplate{
					Offset: input[0].Offset,
					Path:   input[0].Path,
					Type:   rpc.ConvertInternalVodThumbnailType(input[0].Type),
					Url:    input[0].URL,
				},
			}
			So(output, ShouldResemble, ConvertInternalThumbnailTemplates(input))
		})
	})
}
