package converters

import (
	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ConvertToInternalCreateThumbnails converts CreateThumbnails from internal representation to rpc
func ConvertToInternalCreateThumbnails(r *rpc.CreateThumbnailsRequest) *models.CreateThumbnailsRequest {
	thumbnails := make([]models.ThumbnailRequest, len(r.Thumbnails))
	for i, thumbnail := range r.Thumbnails {
		thumbnails[i] = models.ThumbnailRequest{
			Path:   thumbnail.Path,
			Offset: utils.FromProtobufFloat64Value(thumbnail.Offset),
		}
	}
	return &models.CreateThumbnailsRequest{
		VodID:      utils.StrToInt64(r.VodId),
		Thumbnails: thumbnails,
	}
}

// ConvertFromInternalCreateThumbnailsResponse converts CreateThumbnailsResponse map from internal representation to rpc
func ConvertFromInternalCreateThumbnailsResponse(resp *models.CreateThumbnailsResponse) *rpc.CreateThumbnailsResponse {
	thumbnails := make([]*rpc.Thumbnail, len(resp.Thumbnails))
	for i, thumbnail := range resp.Thumbnails {
		thumbnails[i] = &rpc.Thumbnail{
			Path:   thumbnail.Path,
			Offset: utils.ProtobufFloat64Value(thumbnail.Offset),
		}
	}
	return &rpc.CreateThumbnailsResponse{
		Thumbnails: thumbnails,
	}
}

// ConvertFromInternalThumbnailsResponse converts ThumbnailsResponse map from internal representation to rpc
func ConvertFromInternalThumbnailsResponse(resp *models.CreateCustomThumbnailUploadRequestResponse) *rpc.CreateCustomThumbnailUploadRequestResponse {
	return &rpc.CreateCustomThumbnailUploadRequestResponse{
		Url:      resp.URL,
		UploadId: resp.UploadID,
	}
}
