package converters

import (
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestThumbnails(t *testing.T) {
	Convey("when using thumbnails convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting to internal create thumbnails", func() {
			input := &rpc.CreateThumbnailsRequest{
				VodId: "1234",
				Thumbnails: []*rpc.ThumbnailRequest{
					&rpc.ThumbnailRequest{
						Path: "path",
					},
				},
			}
			output := &models.CreateThumbnailsRequest{
				VodID: utils.StrToInt64(input.VodId),
				Thumbnails: []models.ThumbnailRequest{
					models.ThumbnailRequest{
						Path: input.Thumbnails[0].Path,
					},
				},
			}
			So(output, ShouldResemble, ConvertToInternalCreateThumbnails(input))
		})
		Convey("when converting from internal create thumbnails response", func() {
			input := &models.CreateThumbnailsResponse{
				Thumbnails: []models.Thumbnail{
					models.Thumbnail{
						Path: "path",
					},
				},
			}
			output := &rpc.CreateThumbnailsResponse{
				Thumbnails: []*rpc.Thumbnail{
					&rpc.Thumbnail{
						Path: input.Thumbnails[0].Path,
					},
				},
			}
			So(output, ShouldResemble, ConvertFromInternalCreateThumbnailsResponse(input))
		})
		Convey("when converting from internal thumbnails response", func() {
			input := &models.CreateCustomThumbnailUploadRequestResponse{
				URL:      "url",
				UploadID: "upload_id",
			}
			output := &rpc.CreateCustomThumbnailUploadRequestResponse{
				Url:      input.URL,
				UploadId: input.UploadID,
			}
			So(output, ShouldResemble, ConvertFromInternalThumbnailsResponse(input))
		})
	})
}
