package converters

import (
	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ConvertFromInternalUserVideoPrivacyProperties converts UserVideoPrivacyProperties map from internal representation to rpc
func ConvertFromInternalUserVideoPrivacyProperties(resp *models.UserVideoPrivacyPropertiesResponse) *rpc.UserVideoPrivacyPropertiesResponse {
	return &rpc.UserVideoPrivacyPropertiesResponse{
		ChannelId:           utils.Int64ToStr(resp.ChannelID),
		HideArchives:        resp.HideArchives,
		HideArchivesEnabled: resp.HideArchivesEnabled,
		CreatedAt:           utils.ProtobufTimeAsTimestamp(&resp.CreatedAt),
		UpdatedAt:           utils.ProtobufTimeAsTimestamp(&resp.UpdatedAt),
	}
}

// ConvertFromInternalUserVodProperties converts UserVodProperties map from internal representation to rpc
func ConvertFromInternalUserVodProperties(resp *models.UserVodPropertiesResponse) *rpc.UserVodPropertiesResponse {
	return &rpc.UserVodPropertiesResponse{
		ChannelId:                utils.Int64ToStr(resp.ChannelID),
		SaveVodsForever:          resp.SaveVodsForever,
		VodStorageDays:           resp.VodStorageDays,
		CanUploadVod:             resp.CanUploadVod,
		YoutubeExportingDisabled: resp.YoutubeExportingDisabled,
		SkipUploadModeration:     resp.SkipUploadModeration,
		SkipMuting:               resp.SkipMuting,
		CanUploadUnlimited:       resp.CanUploadUnlimited,
		CreatedAt:                utils.ProtobufTimeAsTimestamp(&resp.CreatedAt),
		UpdatedAt:                utils.ProtobufTimeAsTimestamp(&resp.UpdatedAt),
	}
}
