package converters

import (
	"testing"
	"time"

	"code.justin.tv/vod/vodapi/internal/models"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestUserProperties(t *testing.T) {
	Convey("when using user properties convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting from internal user video privacy properties", func() {
			input := &models.UserVideoPrivacyPropertiesResponse{
				ChannelID:           1234,
				HideArchives:        true,
				HideArchivesEnabled: true,
				CreatedAt:           time.Now(),
				UpdatedAt:           time.Now(),
			}
			output := &rpc.UserVideoPrivacyPropertiesResponse{
				ChannelId:           utils.Int64ToStr(input.ChannelID),
				HideArchives:        input.HideArchives,
				HideArchivesEnabled: input.HideArchivesEnabled,
				CreatedAt:           utils.ProtobufTimeAsTimestamp(&input.CreatedAt),
				UpdatedAt:           utils.ProtobufTimeAsTimestamp(&input.UpdatedAt),
			}
			So(output, ShouldResemble, ConvertFromInternalUserVideoPrivacyProperties(input))
		})
		Convey("when converting from internal user vod properties", func() {
			input := &models.UserVodPropertiesResponse{
				ChannelID:                1234,
				SaveVodsForever:          true,
				VodStorageDays:           100,
				CanUploadVod:             true,
				YoutubeExportingDisabled: true,
				SkipUploadModeration:     true,
				SkipMuting:               true,
				CanUploadUnlimited:       true,
				CreatedAt:                time.Now(),
				UpdatedAt:                time.Now(),
			}
			output := &rpc.UserVodPropertiesResponse{
				ChannelId:                utils.Int64ToStr(input.ChannelID),
				SaveVodsForever:          input.SaveVodsForever,
				VodStorageDays:           input.VodStorageDays,
				CanUploadVod:             input.CanUploadVod,
				YoutubeExportingDisabled: input.YoutubeExportingDisabled,
				SkipUploadModeration:     input.SkipUploadModeration,
				SkipMuting:               input.SkipMuting,
				CanUploadUnlimited:       input.CanUploadUnlimited,
				CreatedAt:                utils.ProtobufTimeAsTimestamp(&input.CreatedAt),
				UpdatedAt:                utils.ProtobufTimeAsTimestamp(&input.UpdatedAt),
			}
			So(output, ShouldResemble, ConvertFromInternalUserVodProperties(input))
		})
	})
}
