package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// CreateArchive should make a backend call
func (s *Server) CreateArchive(ctx context.Context, r *rpc.CreateArchiveRequest) (*rpc.CreateArchiveResponse, error) {
	internalResponse, err := s.backend.CreateArchive(ctx, converters.ConvertToInternalCreateArchiveRequest(r))
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.CreateArchiveResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
