package server

import (
	"context"
	"errors"
	"log"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestCreateArchive(t *testing.T) {
	Convey("when calling CreateArchive", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		createArchiveRequest := testdata.CreateArchiveRequest()

		Convey("when CreateArchive succeeds", func() {
			rpcArchive := testdata.RPCArchiveVod()
			log.Println(rpcArchive.CreatedAt.Nanos)
			archiveVod := testdata.ArchiveVod()
			log.Println(archiveVod.CreatedAt.UnixNano())
			mocks.backend.On("CreateArchive", ctx, Anything).Return(archiveVod, nil)
			resp, err := server.CreateArchive(ctx, createArchiveRequest)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.CreateArchiveResponse{Vod: rpcArchive})
		})
		Convey("when CreateArchive fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("CreateArchive", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.CreateArchive(ctx, createArchiveRequest)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
