package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/server/converters"
	"code.justin.tv/vod/vodapi/rpc/vodapi"
)

// CreateAudibleMagicResponses should make a backend call
func (s *Server) CreateAudibleMagicResponses(ctx context.Context, r *vodapi.CreateAudibleMagicResponsesRequest) (*vodapi.AudibleMagicResponsesResponse, error) {
	internalResponse, err := s.backend.CreateAudibleMagicResponses(ctx, converters.ConvertToInternalCreateAudibleMagicResponses(r))
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalAudibleMagicResponses(internalResponse), nil
}
