package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestCreateAudibleMagicResponses(t *testing.T) {
	Convey("when calling CreateAudibleMagicResponses", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := testdata.CreateAudibleMagicResponsesRequest()

		Convey("when CreateAudibleMagicResponses succeeds", func() {
			mocks.backend.On("CreateAudibleMagicResponses", ctx, Anything).Return(testdata.AudibleMagicResponses(), nil)
			resp, err := server.CreateAudibleMagicResponses(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when CreateAudibleMagicResponses fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("CreateAudibleMagicResponses", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.CreateAudibleMagicResponses(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
