package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// CreateError should make a backend call
func (s *Server) CreateError(ctx context.Context, r *rpc.CreateErrorRequest) (*rpc.CreateErrorResponse, error) {
	request := &models.CreateErrorRequest{
		VodID:        utils.StrToInt64(r.VodId),
		ErrorCode:    r.ErrorCode,
		ErrorMessage: r.ErrorMessage,
	}
	internalResponse, err := s.backend.CreateError(ctx, request)
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertCreateError(internalResponse), nil
}
