package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestCreateError(t *testing.T) {
	Convey("when calling CreateError", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.CreateErrorRequest{
			VodId:        utils.Int64ToStr(testdata.VodID1),
			ErrorCode:    "code",
			ErrorMessage: "message",
		}

		Convey("when CreateError succeeds", func() {
			createError := &models.CreateErrorResponse{}
			mocks.backend.On("CreateError", ctx, Anything).Return(createError, nil)
			resp, err := server.CreateError(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when CreateError fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("CreateError", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.CreateError(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
