package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// CreateThumbnails should make a backend call
func (s *Server) CreateThumbnails(ctx context.Context, r *rpc.CreateThumbnailsRequest) (*rpc.CreateThumbnailsResponse, error) {
	internalResponse, err := s.backend.CreateThumbnails(ctx, converters.ConvertToInternalCreateThumbnails(r))
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalCreateThumbnailsResponse(internalResponse), nil
}
