package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestCreateThumbnails(t *testing.T) {
	Convey("when calling CreateThumbnails", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := testdata.CreateThumbnailsRequest()

		Convey("when CreateThumbnails succeeds", func() {
			mocks.backend.On("CreateThumbnails", ctx, Anything).Return(testdata.CreateThumbnailsResponse(), nil)
			resp, err := server.CreateThumbnails(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when CreateThumbnails fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("CreateThumbnails", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.CreateThumbnails(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
