package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// CreateUpload should make a backend call
func (s *Server) CreateUpload(ctx context.Context, r *rpc.CreateUploadRequest) (*rpc.CreateUploadResponse, error) {
	internalResponse, err := s.backend.CreateUpload(ctx, &models.CreateUploadRequest{
		BroadcastType: rpc.ConvertVodType(r.BroadcastType),
		BroadcastID:   utils.StrToInt64(r.BroadcastId),
		OwnerID:       utils.StrToInt64(r.OwnerId),
		Description:   r.Description,
		Duration:      r.Duration,
		URI:           r.Uri,
		Manifest:      r.Manifest,
		Title:         r.Title,
		Game:          r.Game,
		Communities:   r.Communities,
		Language:      r.Language,
		TagList:       r.TagList,
		Viewable:      rpc.ConvertVodViewable(r.Viewable),
		ViewableAt:    utils.FromProtobufTimestampToTime(r.ViewableAt),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.CreateUploadResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
